#ifndef BULLETGUN_H
#define BULLETGUN_H

#include <object.h>
#include <direction.h>

struct BulletGun : public Object {	
	bool *trigger;              //when true, the gun fires
	float force;                //the force of the bullet being fired
	int life;                   //how long the bullet lives
	int cool_down;              //how long after firing the gun must wait to fire again
	int temp;                   //internally used to keep track of cooling down
	float offset;               //how far forward of the direction's position the bullet should appear
	float mass;                 //the mass of the bullet
	int level;
	bool levels[MAXLEVELS];
	Direction *direction;

	BulletGun(Object *parent, bool *trigger = NULL, Direction *direction = NULL, float force = 1.0f, float offset = 0.0f, int cool_down = 10, int life = 50, float mass = 5.0f, int level = 1, const bool levels[MAXLEVELS] = defaultlevels);
	virtual void stepFunc();
};

#endif